<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class WebmailModel extends CI_Model {

	function get_user_theme_info() {
		$this->load->library('session');
		if(strlen($this->session->userdata('username')) > 0) {
			$query = $this->db->query('SELECT * FROM users JOIN themes ON (users.user_theme = themes.theme_id) WHERE user_name=' . $this->db->escape($this->session->userdata('username')));
		}
		else {
			$query = $this->db->query('SELECT * FROM themes WHERE theme_is_default=1');
		}
		return $query;
	}
	function get_log_export($log_name,$start_udate,$end_udate) {
		$where_clause = '';
		switch ($log_name) {
			case 'logins':
				$table_name = 'logins';
				$time_field = 'login_time';
				break;
			case 'sent_mail':
				$table_name = 'mail_log';
				$where_clause = 'inbound_outbound=0 AND ';
				$time_field = 'time';
				break;
			case 'received_mail':
				$table_name = 'mail_log';
				$where_clause = 'inbound_outbound=1 AND ';
				$time_field = 'time';
				break;
			case 'edit':
				$table_name = 'edit_log'; 
				$time_field = 'edit_datetime';
				break;
			case 'feedback':
				$table_name = 'feedback'; 
				$time_field = 'feedback_datetime';
				break;
			default:
				return FALSE;
				break;
		}
		if($start_udate !== FALSE &&  $end_udate !== FALSE && $start_udate < $end_udate) {
			$log = $this->db->query('SELECT * FROM '.$table_name.' WHERE '.$where_clause.$time_field.' BETWEEN ' . $this->db->escape($start_udate) . ' AND ' . $this->db->escape($end_udate) . ' ORDER BY '.$time_field.' DESC');
		}
		else if($start_udate === FALSE && $end_udate !== FALSE) {
			$log = $this->db->query('SELECT * FROM '.$table_name.' WHERE '.$where_clause.$time_field.' BETWEEN 0 AND ' . $this->db->escape($end_udate) . ' ORDER BY '.$time_field.' DESC');
		}
		else if($start_udate !== FALSE && $end_udate === FALSE) {
			$log = $this->db->query('SELECT * FROM '.$table_name.' WHERE '.$where_clause.$time_field.' BETWEEN ' . $this->db->escape($start_udate) . ' AND '.$this->db->escape(time()).' ORDER BY '.$time_field.' DESC');
		}
		else if($start_udate === FALSE && $end_udate === FALSE && strlen($where_clause) > 0) { 
			$log = $this->db->query('SELECT * FROM '.$table_name.' WHERE '.str_replace(' AND ','',$where_clause).'ORDER BY '.$time_field.' DESC'); 
		}
		else { $log = $this->db->query('SELECT * FROM '.$table_name.' ORDER BY '.$time_field.' DESC'); }
		return $log;
	}
	
	function get_user_id($username) {
		if(empty($username) || !is_string($username)) return false;
		return $this->db->query('SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=' . $this->db->escape($username));
	}
	
	function create_user_record($attributes) {
		if(isset($attributes['edipi']) && isset($attributes['piv_id'])) {
			$create_user_rec = $this->db->query('INSERT INTO users (user_edipi,user_piv_id,user_name,user_mail,user_theme,user_ep,user_created_by,user_created_date,user_ext_notify_flag,user_ext_group_notify_flag,user_deleted_flag,user_is_group) VALUES (' . $this->db->escape($attributes['edipi']) . ',' . $this->db->escape($attributes['piv_id']) . ',' . $this->db->escape($attributes['username']) . ',' . $this->db->escape($attributes['ext_mail']) . ',(SELECT theme_id FROM themes WHERE theme_is_default=1),' . $this->db->escape($this->encrypt->encode($attributes['pass'])). ',' . $this->db->escape($attributes['actor_id']) . ',' . $this->db->escape(date('U')) . ',' . $this->db->escape($attributes['user_ext_notify_flag']) .','.$this->db->escape($attributes['user_ext_group_notify_flag']).','.$this->db->escape($attributes['user_deleted_flag']).','.$this->db->escape($attributes['user_is_group']).')');
		}
		else if(isset($attributes['edipi'])) {
			$create_user_rec = $this->db->query('INSERT INTO users (user_edipi,user_name,user_mail,user_theme,user_ep,user_created_by,user_created_date,user_ext_notify_flag,user_ext_group_notify_flag,user_deleted_flag,user_is_group) VALUES (' . $this->db->escape($attributes['edipi']) . ',' . $this->db->escape($attributes['username']) . ',' . $this->db->escape($attributes['ext_mail']) . ',(SELECT theme_id FROM themes WHERE theme_is_default=1),' . $this->db->escape($this->encrypt->encode($attributes['pass'])). ',' . $this->db->escape($attributes['actor_id']) . ',' . $this->db->escape(date('U')) . ',' . $this->db->escape($attributes['user_ext_notify_flag']) .','.$this->db->escape($attributes['user_ext_group_notify_flag']).','.$this->db->escape($attributes['user_deleted_flag']).','.$this->db->escape($attributes['user_is_group']).')');

		}
		else if(isset($attributes['piv_id'])) {
			$create_user_rec = $this->db->query('INSERT INTO users (user_piv_id,user_name,user_mail,user_theme,user_ep,user_created_by,user_created_date,user_ext_notify_flag,user_ext_group_notify_flag,user_deleted_flag,user_is_group) VALUES ('.$this->db->escape($attributes['piv_id']) . ',' . $this->db->escape($attributes['username']) . ',' . $this->db->escape($attributes['ext_mail']) . ',(SELECT theme_id FROM themes WHERE theme_is_default=1),' . $this->db->escape($this->encrypt->encode($attributes['pass'])). ',' . $this->db->escape($attributes['actor_id']) . ',' . $this->db->escape(date('U')) . ',' . $this->db->escape($attributes['user_ext_notify_flag']) .','.$this->db->escape($attributes['user_ext_group_notify_flag']).','.$this->db->escape($attributes['user_deleted_flag']).','.$this->db->escape($attributes['user_is_group']).')');
		}
		else if(!isset($attributes['edipi']) && !isset($attributes['piv_id']) && $attributes['user_is_group'] === 1) {
			$create_user_rec = $this->db->query('INSERT INTO users (user_name,user_mail,user_theme,user_ep,user_created_by,user_created_date,user_ext_notify_flag,user_ext_group_notify_flag,user_deleted_flag,user_is_group) VALUES ('.$this->db->escape($attributes['username']) . ',' . $this->db->escape($attributes['ext_mail']) . ',(SELECT theme_id FROM themes WHERE theme_is_default=1),' . $this->db->escape($this->encrypt->encode($attributes['pass'])). ',' . $this->db->escape($attributes['actor_id']) . ',' . $this->db->escape(date('U')) . ',' . $this->db->escape($attributes['user_ext_notify_flag']) .','.$this->db->escape($attributes['user_ext_group_notify_flag']).','.$this->db->escape($attributes['user_deleted_flag']).','.$this->db->escape($attributes['user_is_group']).')');
		}
		else { return FALSE; }
		return $create_user_rec;
	}
	
	function is_deactivated($type, $id) {
		switch (strtolower($type)) {
			case 'piv':
				$piv_check = $this->db->query('SELECT user_piv_id FROM users WHERE user_deleted_flag=1 AND user_piv_id=' . $this->db->escape($id));
				if($piv_check->num_rows() > 0) { return TRUE; }
				else { return FALSE; }
				break;
			case 'cac':
				$edipi_check = $this->db->query('SELECT user_edipi FROM users WHERE user_deleted_flag=1 AND user_edipi=' . $this->db->escape($id));
				if($edipi_check->num_rows() > 0) { return TRUE; }
				else { return FALSE; }
				break;
			default:
				return NULL;
				break;
		}
	}
	
	/* This function simply checks if an EDIPI exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the EDIPI exists and FALSE if it does not.
	 */
	function edipi_exists($edipi) {
		$edipi_check = $this->db->query('SELECT user_edipi FROM users WHERE user_edipi=' . $this->db->escape($edipi));
		if($edipi_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function simply checks if a PIV ID exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the PIV ID exists and FALSE if it does not.
	 */
	function piv_exists($piv_id) {
		$piv_check = $this->db->query('SELECT user_piv_id FROM users WHERE user_piv_id=' . $this->db->escape($piv_id));
		if($piv_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
}